//
// Copyright 2010-2011 Justin.tv. All rights reserved.
//

#import "NSNumberAdditions.h"

@implementation NSNumberFormatter (Additions)
- (NSString *) cachedStringFromNumber:(NSNumber *) number {
	static NSMutableDictionary *formattedStringCache = nil;
	if (!formattedStringCache)
		formattedStringCache = [[NSMutableDictionary alloc] init];

	NSString *cachedString = formattedStringCache[number];
	if (!cachedString) {
		cachedString = [self stringFromNumber:number];

		formattedStringCache[number] = cachedString;
	}

	return cachedString;
}
@end

@implementation NSNumber (Additions)
+ (NSNumberFormatter *) formatter {
	NSNumberFormatter *formatter = [NSThread currentThread].threadDictionary[@"number-formatter"];
	if (!formatter) {
		formatter = [[NSNumberFormatter alloc] init];
		formatter.numberStyle = NSNumberFormatterDecimalStyle;

		[NSThread currentThread].threadDictionary[@"number-formatter"] = formatter;

	}

	return formatter;
}

- (NSString *) formattedLocalizedNumericRepresentation {
	return [[[self class] formatter] cachedStringFromNumber:self];
}
@end
